# fixed and random effects models

#install.packages(c("pcse","plm","Hmisc","lme4","arm"), dep=T)

library(foreign)
library(pcse)  # a package enabling the estimation of Panel-Corrected Standard Errors
library(plm)	# the panel linear models library.
library(Hmisc)


read.dta("505-pooled-se.dta")->data    

# Data prep
############

data<-subset(data, data$year>1977 & data$year<2001)
data<-subset(data, data$stname!="District of Columbia")

# per capita police spending, state + local
data$policePC = data$policeex1/data$totalpop
# per capita welfare spending, state + local
data$welfarePC = data$welfare1/data$totalpop
# per capita education spending, state + local
data$edspendPC = data$edspend1/data$totalpop
# log population
data$logpop = log(data$totalpop)
# log per capita income
data$logpcinc = log(data$PInccapC)

attach(data)

# read data into PLM package
data.plm<-pdata.frame(data, index=c("stfips", "year"), drop.index=T, row.names=T)

# same ols model as before
model.plm <- plm(murder~adperI+policePC+edspendPC+logpcinc+logpop, data=data.plm, model="pooling")
summary(model.plm)

# your basic FE model with state-level dummy variables
model.plm.fe <- plm(murder~adperI+policePC+edspendPC+logpcinc+logpop, data=data.plm, model="within")
summary(model.plm.fe)

# state dummies AND year/time dummies
model.plm.fe.2 <- plm(murder~adperI+policePC+edspendPC+logpcinc+logpop, data=data.plm, effects="twoways", model="within")
summary(model.plm.fe.2)

# use multiple techniques simultaneously
# cluster-robust SEs with state and year dummies
sqrt(diag( vcovHC(model.plm.fe.2, cluster="group") ))

# Beck & Katz PCSEs with state and year dummies
sqrt(diag(vcovBK(model.plm.fe.2)))

# difference in difference estimate for uniform control of the legislature
model.plm.fe.3 <- plm(murder~unifcont+adperI+policePC+edspendPC+logpcinc+logpop, data=data.plm, effects="twoways", model="within")
summary(model.plm.fe.3)
sqrt(diag( vcovHC(model.plm.fe.3, cluster="group") ))


# maybe uniform control of the legislature has an effect on government policy?
model.plm.fe.4 <- plm(policePC~unifcont, data=data.plm, effects="twoways", model="within")
summary(model.plm.fe.4)
sqrt(diag( vcovHC(model.plm.fe.4, cluster="group") ))

# on log per capita income?
model.plm.fe.5 <- plm(logpcinc~unifcont, data=data.plm, effects="twoways", model="within")
summary(model.plm.fe.5)
sqrt(diag( vcovHC(model.plm.fe.5, cluster="group") ))



# another difference in difference example
# featured on https://thetarzan.wordpress.com/2011/06/20/differences-in-differences-estimation-in-r-and-stata/
rm(list=ls())
require(foreign)

# update: first download the file eitc.dta from this link:
# https://docs.google.com/open?id=0B0iAUHM7ljQ1cUZvRWxjUmpfVXM
# Then import from your hard drive:
eitc = read.dta("eitc.dta")

# Create two additional dummy variables to indicate before/after
# and treatment/control groups.

# the EITC went into effect in the year 1994
eitc$post93 = as.numeric(eitc$year >= 1994)

# The EITC only affects women with at least one child, so the
# treatment group will be all women with children.
eitc$anykids = as.numeric(eitc$children >= 1)


eitc$p93kids.interaction = eitc$post93*eitc$anykids

reg1 = lm(work ~ post93 + anykids + p93kids.interaction + as.factor(state) + as.factor(year), data=eitc)
summary(reg1)