rm(list=ls())
library(foreign)

dat <- read.dta("duration.dta")
dat <- subset(dat, subset=marker==1)

library(survival)

dat$failed <- as.numeric(is.na(dat$censored))

surv.dat <- Surv(time=dat$calcdur, event=dat$failed, type="right")
kapmeier <- survfit(surv.dat ~ 1, conf.int = 0.95)
plot(kapmeier)


kapmeier <- survfit(surv.dat ~ dat$allies)
plot(kapmeier)

idx <- which(kapmeier$strata==1)
plot(kapmeier$surv[1:kapmeier$strata[1]] ~ kapmeier$time[1:kapmeier$strata[1]], type="l")
lines(kapmeier$surv[(kapmeier$strata[1]+1):(kapmeier$strata[1] + kapmeier$strata[2])] ~kapmeier$time[(kapmeier$strata[1]+1): (kapmeier$strata[1] + kapmeier$strata[2]) ], lty=2)
legend(legend = c("No allies", "Allies"), x="topright", lty=c(1,2))



cox.mod <- coxph(surv.dat ~ dat$ldistance + dat$lev4cont + dat$powdisparity + dat$allies + dat$jointdem + dat$kdeplo)
summary(cox.mod)

cox.zph(cox.mod, transform="km", global=TRUE)
cox.zph(cox.mod, transform="identity", global=TRUE)
cox.zph(cox.mod, transform="rank", global=TRUE)


dat.sp <- survSplit(dat, cut=unique(dat$calcdur), start="start", end="calcdur", event = "failed")
cox.mod.1 <- coxph(Surv(start, calcdur, failed) ~ ldistance + lev4cont + powdisparity + allies + jointdem + kdeplo, data=dat.sp)
summary(cox.mod.1)
# the same - good

dat.sp$lt_allies <- dat.sp$allies * log(dat.sp$calcdur)
dat.sp$lt_jointdem <- dat.sp$jointdem * log(dat.sp$calcdur)

cox.mod.2 <- coxph(Surv(start, calcdur, failed) ~ ldistance + lev4cont + powdisparity + allies + jointdem + kdeplo + lt_allies + lt_jointdem, data=dat.sp)
summary(cox.mod.2)

cox.zph(cox.mod.2, transform="km", global=TRUE)


