
set mem 16m
use duration.dta

describe
su

*We stset the data for the time-fixed covariate models:

capture stset, clear
stset calcdur if marker==1, failure(censored==.)

* Kaplan-Meier graph
sts graph 
sts graph, ci
sts graph, by(allies)

*First, we are going to estimate a control model that regresses MID duration only
*on the control variables:

stcox ldistance lev4cont powdisparity allies jointdem, efron nohr
stcox ldistance lev4cont powdisparity allies jointdem, efron nolog

*Next, we add the lower trade-to-GDP ratio in the disputing dyad to model with time-fixed covariates:

* try a Weibull model

streg ldistance lev4cont powdisparity allies jointdem kdeplo, distribution(weibull)

************* Table I.1*************************
stcox ldistance lev4cont powdisparity allies jointdem kdeplo, efron nohr

*Now it is time to test the important proportionality assumption:

stphplot, by(allies)
stphplot, by(jointdem)

stcoxkm, by(allies) separate
stcoxkm, by(jointdem) separate

estat phtest
estat phtest, log



*To amend for the disproportionality of the offending variables, we interact them with ln(time):

************* Table I.2*************************
stcox ldistance lev4cont powdisparity allies jointdem kdeplo, tvc(allies jointdem) texp( ln(_t) ) efron nohr
************************************************
lrtest, saving(0)
qui stcox ldistance lev4cont powdisparity allies jointdem kdeplo, efron nohr
lrtest, using(0)

*We apply the same test to the modified model to check if the detected disproportionality has been corrected:

stcox ldistance lev4cont powdisparity allies jointdem kdeplo, tvc(allies jointdem) texp( ln(_t) ) efron nohr
estat phtest

